<?php
/**
 * Functions
 *
 * @package     AutomatorWP\Integrations\Invite_Anyone\Functions
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

/**
 * Accept invite listener
 *
 * @since 1.0.0
 *
 * @param int   $user_id    Invited user ID
 * @param array $inviters   Array of user IDs that invited the user
 */
function automatorwp_invite_anyone_accept_invite_listener( $user_id, $inviters ) {

    if ( empty( $inviters ) ) return;

    // Invite Anyone will pass on an array of user IDs of those who have invited this user which we need to loop though
    foreach ( (array) $inviters as $inviter_id ) {

        // Check if signup requires activation key
        if ( apply_filters( 'bp_core_signup_send_activation_key', true ) ) {

            // Get pending invites list
            $pending = get_transient( 'automatorwp_invite_anyone_pending_invites' );

            if ( $pending === false ) $pending = array();

            // Add to pending list invites if not there already
            if ( ! isset( $pending[$user_id] ) ) {
                $pending[$user_id] = $inviter_id;

                delete_transient( 'automatorwp_invite_anyone_pending_invites' );
                set_transient( 'automatorwp_invite_anyone_pending_invites', $pending, 7 * DAY_IN_SECONDS );
            }

        } else {

            // Trigger a custom hook to make work our triggers
            do_action( 'automatorwp_invite_anyone_invite_accepted', $user_id, $inviter_id );


        }

    }

}
add_action( 'accepted_email_invite', 'automatorwp_invite_anyone_accept_invite_listener', 10, 2 );

/**
 * Account activated listener
 *
 * @since 1.0.0
 *
 * @param int   $user_id    Invited user ID
 */
function automatorwp_invite_anyone_activated_user_listener( $user_id ) {

    // Get pending invites list
    $pending = get_transient( 'automatorwp_invite_anyone_pending_invites' );

    // Bail if not pending invites
    if ( $pending === false || ! isset( $pending[$user_id] ) ) {
        return;
    }

    $inviter_id = $pending[$user_id];

    // Trigger a custom hook to make work our triggers
    do_action( 'automatorwp_invite_anyone_invite_accepted', $user_id, $inviter_id );

    // Remove from list
    unset( $pending[$user_id] );

    // Update pending list
    delete_transient( 'automatorwp_invite_anyone_pending_invites' );
    set_transient( 'automatorwp_invite_anyone_pending_invites', $pending, 7 * DAY_IN_SECONDS );

}
add_action( 'bp_core_activated_user', 'automatorwp_invite_anyone_activated_user_listener' );